﻿
Param($Reboot)

# $update_url = 'https://sikiapp.net/siki-updates/latest-asar.txt'
$update_url = 'https://sikiapp.net/siki-updates/beta-asar.txt'

$wsobj = New-Object -comobject wscript.shell
$wc = New-Object System.Net.WebClient 
$tmp_dir = "${env:TEMP}\tmp." + (Get-Random -Minimum 10000 -Maximum 100000)
try {
  Set-Location  $PSScriptRoot
  if (Get-Process -Name "siki" -ErrorAction SilentlyContinue) {
    $wsobj.popup('Sikiを終了してから実行してください', 0, 'Error')
    Exit
    # Stop-Process  -name siki
  }

  $exe_version = (Get-ItemProperty '.\Siki.exe' | Select-Object).VersionInfo.FileVersion

  Write-Host ("exe:${exe_version}`nurl:${update_url}")
  $txt = $wc.DownloadString($update_url)
  if ($txt -match '^(\d+\.\d+\.\d+[\S]*)\n(\w+)') {
    $version = $Matches[1]
    $new_hash = $Matches[2]
    # $current_hash = (Get-FileHash './resources/app.asar').Hash
    $current_hash = (certutil -hashfile './resources/app.asar' SHA256)[1]
    if (-not $current_hash -or -not $exe_version) {
      $wsobj.popup('ファイルの場所が不明。', 10, 'Error')
    }
    elseif ($new_hash -eq $current_hash) {
      $wsobj.popup('更新はありませんでした。', 10, $version)
    }
    else {
      New-Item $tmp_dir -ItemType Directory -Force
      $filename = "app.asar-${version}.zip"
      $app_link = "https://sikiapp.net/archives/${version}/${filename}"
      $wc.DownloadFile($app_link, $($tmp_dir + "\" + $filename))
      Expand-Archive -Path "${tmp_dir}\${filename}" -Force -DestinationPath "${tmp_dir}"
      Write-Host (certutil -hashfile "${tmp_dir}\app.asar" SHA256)[1]
      if ((certutil -hashfile "${tmp_dir}\app.asar" SHA256)[1] -ne $new_hash) {
        $wsobj.popup('hash値が違うためアップデートできません', 10, 'アップデート失敗')
      }
      else {
        Move-Item -Path "${tmp_dir}\app.asar" -Destination '.\resources\app.asar'  -Force
        $wsobj.popup("${version} へアップデートしました。`n`nAsarバージョン: ${version}`nexeバージョン:${exe_version}", 10, 'アップデート完了')
      }
    }
  }
  else {
    $wsobj.popup('最新のバージョン情報取得に失敗しました。', 0, 'Error')
  }
}
catch {
  $wsobj.popup($_, 0, 'Error')
}
finally {
  if (Test-Path $tmp_dir) {
    Remove-Item $tmp_dir -Recurse
  }
  if ($Reboot) {
    cmd.exe /c start "" .\Siki.exe
  }
}